<?php
require_once "db.php";
 
/*    ELIMINAR PRODUCTO */
 
if (isset($_GET["eliminar"])) {
    $id = (int) $_GET["eliminar"];
    $conexion->query("DELETE FROM lista_compra WHERE id = $id");
    header("Location: index.php");
    exit;
}
 
 /*   MARCAR / DESMARCAR COMO COMPRADO */
 
if (isset($_GET["toggle"])) {
    $id = (int) $_GET["toggle"];
    // Obtener el estado actual
    $res = $conexion->query("SELECT comprado FROM lista_compra WHERE id=$id");
    $fila = $res->fetch_assoc();
    $nuevo = $fila["comprado"] ? 0 : 1;
    $conexion->query("UPDATE lista_compra SET comprado=$nuevo WHERE id=$id");
    header("Location: index.php");
    exit;
}

  /*  AGREGAR PRODUCTO */

if (isset($_POST["agregar"])) {
    $producto = trim($_POST["producto"]);
    $tienda   = trim($_POST["tienda"]);

    if ($producto && $tienda) {
        $stmt = $conexion->prepare(
            "INSERT INTO lista_compra (productos, tiendas, comprado) VALUES (?, ?, 0)"
        );
        $stmt->bind_param("ss", $producto, $tienda);
        $stmt->execute();
    }
}

  /*  BUSCAR PRODUCTO */

$buscar = $_GET["buscar"] ?? "";
$stmt = $conexion->prepare(
    "SELECT id, productos, tiendas, comprado 
     FROM lista_compra
     WHERE productos LIKE ? OR tiendas LIKE ?
     ORDER BY tiendas, productos"
);
$like = "%$buscar%";
$stmt->bind_param("ss", $like, $like);
$stmt->execute();
$resultado = $stmt->get_result();


  /*  ORGANIZAR POR TIENDA */

$listado = [];
while ($fila = $resultado->fetch_assoc()) {
    $tienda = $fila["tiendas"];
    $listado[$tienda][] = $fila;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>Lista de la Compra</title>

</head>

<body>

    <h2>🛒 Lista de la Compra</h2>
   <div class="nuevo">
    <h3>➕ Agregar producto</h3>

    <form method="post" id="formProducto">
        <input type="text" id="producto" name="producto" placeholder="Producto" required>
        <input type="text" id="tienda" name="tienda" placeholder="Tienda" required>

        <button class="agregar" name="agregar">Agregar</button>
        <button type="button" onclick="iniciarVoz()" style="margin-top:8px;">
            🎤 Añadir por Vozarron
        </button>
    </form>
</div>


    <form class="buscar" method="get">
        <input type="search" name="buscar" placeholder="Buscar producto o tienda"
            value="<?= htmlspecialchars($buscar) ?>">
    </form>


    <?php foreach ($listado as $tienda => $productos): ?>
        <div class="tienda">
            <h3><?= htmlspecialchars($tienda) ?></h3>
            <?php foreach ($productos as $p): ?>
                <div class="producto">
                    <span class="<?= $p['comprado'] ? 'comprado' : '' ?>">
                        <?= htmlspecialchars($p['productos']) ?>
                    </span>
                    <div style="display:flex; gap:6px;">
                        <form method="get" style="margin:0;">
                            <input type="hidden" name="toggle" value="<?= $p['id'] ?>">
                            <button class="comprar" type="submit">
                                <?= $p['comprado'] ? 'Desmarcar' : '✔' ?>
                            </button>
                        </form>
                        <form method="get" style="margin:0;">
                            <input type="hidden" name="eliminar" value="<?= $p['id'] ?>">
                            <button class="eliminar" type="submit"
                                onclick="return confirm('¿Eliminar este producto?');">
                                🗑
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
<script>
const tiendasConocidas = [
    "Mercadona","Carrefour","Lidl","Aldi","Dia","Alcampo","Eroski",
    "Hipercor","Consum","El Corte Inglés","Walmart","Costco","Tesco",
    "Sainsbury's","Asda","Ikea","Decathlon","Zara","H&M","Primark",
    "Sephora","Douglas","MediaMarkt","Fnac","Game","PC Componentes",
    "Amazon","eBay","Supeco","Coviran","Spar","BM Supermercados",
    "Makro","Donde las haya","La Plaza de Dia","Simply","Ahorramas",
    "Maskom","Alvi","Gadis","Hiper Usera","La Sirena","Carrefour Express"
];

function iniciarVoz() {
    if (!('webkitSpeechRecognition' in window)) {
        alert("Tu navegador no soporta reconocimiento de voz");
        return;
    }

    const recognition = new webkitSpeechRecognition();
    recognition.lang = "es-ES";
    recognition.interimResults = false;

    recognition.start();

    recognition.onresult = function(event) {
        let texto = event.results[0][0].transcript.toLowerCase().trim();

        // Limpieza básica
        texto = texto.replace(/comprar|compra|necesito|quiero|añadir/g, "").trim();

        let producto = "";
        let tienda = "";

        // Detectar "en"
        if (texto.includes(" en ")) {
            const partes = texto.split(" en ");
            producto = partes[0].trim();
            tienda = capitalizar(partes[1].trim());
        } else {
            // Autodetectar tienda conocida
            tiendasConocidas.forEach(t => {
                if (texto.includes(t.toLowerCase())) {
                    tienda = t;
                    producto = texto.replace(t.toLowerCase(), "").trim();
                }
            });
        }

        // Fallback
        if (!tienda) tienda = "Tienda";
        if (!producto) producto = texto;

        document.getElementById("producto").value = capitalizar(producto);
        document.getElementById("tienda").value = capitalizar(tienda);

        hablar("Producto añadido");
    };

    recognition.onerror = function() {
        hablar("No te he entendido, inténtalo otra vez");
    };
}

function capitalizar(texto) {
    return texto.charAt(0).toUpperCase() + texto.slice(1);
}

</script>

</body>

</html>