<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMC</title>

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #ececec, #d9e4f5);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .card {
            background: #fff;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            text-align: center;
            max-width: 350px;
            width: 90%;
            animation: fade 0.8s ease;
        }

        h1 {
            font-size: 26px;
            margin-bottom: 15px;
            color: #333;
        }

        p {
            font-size: 18px;
            color: #555;
            margin: 8px 0;
        }

        @keyframes fade {
            from { opacity: 0; transform: translateY(10px); }
            to   { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="card">
        <h1>Resultado IMC</h1>

        <?php
        $peso_kg = 68;
        $estatura_metros = 1.66;
        $imc = $peso_kg / ($estatura_metros * $estatura_metros);

        echo "<p><strong>Peso:</strong> $peso_kg kg</p>";
        echo "<p><strong>Altura:</strong> $estatura_metros m</p>";
        echo "<p><strong>IMC:</strong> " . round($imc, 2) . "</p>";
        ?>
    </div>
</body>
</html>
