

<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Generador de Gráfica</title>
    <!-- Chart.js CDN -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root{ --accent: #2b6cb0; --muted:#666 }
        body{ font-family: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial; margin:0; padding:20px; background:#f6f8fb; color:#111 }
        .container{ max-width:1100px; margin:0 auto }
        h1{ font-size:1.4rem; margin:0 0 12px }
        .grid{
            display:grid;
            grid-template-columns: 420px 1fr;
            gap:20px;
            align-items:start;
        }
        /* Responsive */
        @media (max-width:800px){
            .grid{ grid-template-columns: 1fr }
        }

        .card{ background:white; border-radius:12px; box-shadow:0 6px 18px rgba(15,23,42,0.06); padding:16px }
        form .row{ display:flex; gap:8px; margin-bottom:8px }
        form input[type="text"], form input[type="number"], form input[type="color"]{ padding:8px; border-radius:8px; border:1px solid #e6eef8; font-size:0.95rem }
        form input[type="number"]{ width:110px }
        form input[type="text"]{ flex:1 }
        form input[type="color"]{ width:56px; padding:3px }
        table.customTable{ width:100%; border-collapse:collapse }
        table.customTable td{ padding:6px }
        .actions{ display:flex; gap:8px; margin-top:8px }
        button, input[type="submit"]{ background:var(--accent); color:white; border:none; padding:8px 12px; border-radius:10px; cursor:pointer }
        button.secondary{ background:transparent; color:var(--accent); border:1px solid rgba(43,108,176,0.12) }
        .errors{ color:#b91c1c; margin-bottom:8px }

        /* Área de la gráfica */
        .chart-area{ display:flex; flex-direction:column; gap:12px }
        canvas{ max-width:100%; height:auto }
        .meta{ font-size:0.9rem; color:var(--muted) }
    </style>
</head>
<body>
<div class="container">
    <h1>Crear gráfica de resultados</h1>
    <div class="grid">
        <div class="card">
            <form action="" method="post">
                <?php if (!empty($errors)): ?>
                    <div class="errors">
                        <strong>Errores:</strong>
                        <ul>
                            <?php foreach ($errors as $e): ?>
                                <li><?= clean($e) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <table class="customTable">
                    <?php for ($i=1;$i<=4;$i++): ?>
                        <tr>
                            <td><input type="text" name="partido<?= $i ?>" placeholder="Partido" value="<?= isset($_POST["partido$i"]) ? clean($_POST["partido$i"]) : '' ?>" required></td>
                            <td><input type="number" name="votos<?= $i ?>" placeholder="Votos" value="<?= isset($_POST["votos$i"]) ? clean($_POST["votos$i"]) : '' ?>" min="0" step="1" required></td>
                            <td><input type="color" name="color<?= $i ?>" value="<?= isset($_POST["color$i"]) ? clean($_POST["color$i"]) : '#'.dechex(rand(0,0xFFFFF)) ?>" required></td>
                        </tr>
                    <?php endfor; ?>
                </table>

                <div class="actions">
                    <input type="submit" value="Crear Gráfica">
                    <button type="button" class="secondary" onclick="document.querySelector('form').reset();">Limpiar</button>
                </div>

                <p class="meta"> <strong>Crear Gráfica</strong></p>
            </form>
        </div>

        <div class="card">
            <div class="chart-area">
                <?php if (!empty($labels) && empty($errors)): ?>
                    <canvas id="myChart" aria-label="Gráfica de votos" role="img"></canvas>
                    <div style="display:flex;gap:8px;align-items:center">
                        <button id="downloadBtn">Descargar PNG</button>
                        <button id="toggleType" class="secondary">Cambiar a barras</button>
                    </div>

                    <script>
                      
                        const labels = <?= json_encode($labels, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
                        const votes = <?= json_encode($votes) ?>;
                        const colors = <?= json_encode($colors) ?>;

                        let chartType = 'pie';
                        const ctx = document.getElementById('myChart').getContext('2d');

                        const config = {
                            type: chartType,
                            data: {
                                labels: labels,
                                datasets: [{
                                    label: 'Votos',
                                    data: votes,
                                    backgroundColor: colors,
                                    borderColor: '#ffffff',
                                    borderWidth: 1
                                }]
                            },
                            options: {
                                responsive: true,
                                plugins: {
                                    legend: { position: 'bottom' },
                                    tooltip: { mode: 'index' }
                                }
                            }
                        };

                        let myChart = new Chart(ctx, config);

                        document.getElementById('downloadBtn').addEventListener('click', function(){
                            const a = document.createElement('a');
                            a.href = myChart.toBase64Image();
                            a.download = 'grafica_votos.png';
                            a.click();
                        });

                        document.getElementById('toggleType').addEventListener('click', function(){
                            const newType = myChart.config.type === 'pie' ? 'bar' : 'pie';
                            const datasets = myChart.data.datasets;
                         
                            datasets[0].borderColor = newType === 'bar' ? '#00000000' : '#ffffff';

                            myChart.destroy();
                            myChart = new Chart(ctx, { ...config, type: newType });
                        });
                    </script>
            </div>
        </div>
    </div>
</div>
</body>
</html>

 

