<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Conversor de Divisas</title>
</head>

<body>

    <h2>Conversor de Euros</h2>

    <form method="post">

        Cantidad en euros:
        <input type="number" name="euros" step="0.01" required>

        <br><br>

        Selecciona la divisa:
        <select name="divisa">
            <option value="usd">Dólar (USD)</option>
            <option value="gbp">Libras (GBP)</option>
            <option value="jpy">Yen Japonés (JPY)</option>
            <option value="mxn">Peso Mexicano (MXN)</option>
            <option value="chf">Franco Suizo (CHF)</option>
        </select>

        <br><br>

        <input type="submit" value="Convertir">
    </form>

    <?php
    if ($_SERVER["REQUEST_METHOD"] == "POST") {

        $euros = $_POST["euros"];
        $divisa = $_POST["divisa"];

        $cambio = [
            "usd" => 1.07,
            "gbp" => 0.85,
            "jpy" => 164.50,
            "mxn" => 19.80,
            "chf" => 0.96
        ];

        $nombres = [
            "usd" => "Dólares",
            "gbp" => "Libras",
            "jpy" => "Yenes",
            "mxn" => "Pesos Mexicanos",
            "chf" => "Francos Suizos"
        ];

        if (isset($cambio[$divisa])) {
            $resultado = $euros * $cambio[$divisa];
            echo "<h3>$euros € equivalen a " . number_format($resultado, 2) . " " . $nombres[$divisa] . ".</h3>";
        } else {
            echo "<h3>Error: divisa no válida.</h3>";
        }
    }
    ?>

</body>

</html>