<?php

$paso = 1;


if (isset($_POST['cantidad']) && !isset($_POST['votos0'])) {
    $paso = 2;
}


if (isset($_POST['votos0'])) {
    $paso = 3;
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de escrutinio</title>
</head>

<body>

    <?php if ($paso == 1): ?>

        <h1>Cantidad de Partidos</h1>

        <form method="post">
            <fieldset>
                <legend>Cantidad:</legend>
                <input type="number" name="cantidad" required min="2" max="25">
                <input type="submit" value="Continuar">
            </fieldset>
        </form>


    <?php elseif ($paso == 2): ?>

        <?php $cantidad = intval($_POST['cantidad']); ?>

        <h1>Ingresar datos de <?= $cantidad ?> partidos</h1>

        <form method="post">
            <input type="hidden" name="cantidad" value="<?= $cantidad ?>">

            <table border="1" cellpadding="5">
                <thead>
                    <tr>
                        <th>Partido</th>
                        <th>Votos</th>
                        <th>Color</th>
                    </tr>
                </thead>
                <tbody>
                    <?php for ($p = 0; $p < $cantidad; $p++): ?>
                        <tr>
                            <td><input type="text" name="partido<?= $p ?>" required></td>
                            <td><input type="number" name="votos<?= $p ?>" required min="0"></td>
                            <td><input type="color" name="color<?= $p ?>" required></td>
                        </tr>
                    <?php endfor; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3"><input type="submit" value="Crear Gráfica"></th>
                    </tr>
                </tfoot>
            </table>
        </form>


    <?php elseif ($paso == 3): ?>

        <?php
        $cantidad = intval($_POST['cantidad']);
        $totalVotos = 0;

        for ($p = 0; $p < $cantidad; $p++) {
            $totalVotos += intval($_POST['votos' . $p]);
        }
        ?>

        <style>
            main {
                display: grid;
                grid-template-columns: repeat(<?= $cantidad ?>, 1fr);
                gap: 10px;
                margin-top: 20px;
                align-items: flex-end;
            }

            main div {
                display: flex;
                align-items: flex-end;
                justify-content: center;
                color: white;
                font-weight: bold;
                padding: 5px;
            }
        </style>

        <h1>Resultados — Total votos: <?= $totalVotos ?></h1>

        <main>
            <?php
            for ($p = 0; $p < $cantidad; $p++) {
                $votos = intval($_POST["votos" . $p]);
                $partido = $_POST["partido" . $p];
                $color = $_POST["color" . $p];

                $altura = ($totalVotos > 0) ? ($votos / $totalVotos) * 400 : 0;
            ?>
                <div style="height: <?= $altura ?>px; background-color: <?= $color ?>;">
                    <?= "$partido: $votos" ?>
                </div>
            <?php } ?>
        </main>

        <br><br>
        <form method="post">
            <input type="submit" value="Volver al inicio">
        </form>

    <?php endif; ?>

</body>

</html>