<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bruto y Neto</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background: #f6f8fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        table {
            border-collapse: collapse;
            width: 350px;
            background: white;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            overflow: hidden;
        }

        caption {
            background: #007bff;
            color: white;
            font-size: 1.3rem;
            font-weight: bold;
            padding: 12px;
        }

        th, td {
            text-align: left;
            padding: 12px 16px;
        }

        th {
            background-color: #f0f0f0;
            font-weight: 600;
        }

        tr:nth-child(even) {
            background-color: #fafafa;
        }

        tr:hover {
            background-color: #e8f0fe;
        }

        td:last-child {
            text-align: right;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <?php
    $bruto = 400;
    $neto = $bruto / 1.21;
    $iva = $bruto - $neto;
    ?>

    <table>
        <caption>Detalle del importe</caption>
        <tr>
            <th>Concepto</th>
            <th>Importe (€)</th>
        </tr>
        <tr>
            <td>Importe bruto</td>
            <td><?php echo number_format($bruto, 2); ?></td>
        </tr>
        <tr>
            <td>Importe neto</td>
            <td><?php echo number_format($neto, 2); ?></td>
        </tr>
        <tr>
            <td>IVA (21%)</td>
            <td><?php echo number_format($iva, 2); ?></td>
        </tr>
    </table>
</body>
</html>
